function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = World_Economy_Competitive.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(33, 60);
g1(1,32)=(-(params(11)*T(26)*T(27)));
g1(1,35)=exp(y(35));
g1(1,13)=(-(T(27)*(1-params(11))*T(2)*T(4)*T(30)*T(31)));
g1(1,37)=(-(T(27)*(1-params(11))*T(2)*T(31)*T(38)));
g1(1,42)=(-(T(27)*T(6)*(1-params(11))*T(1)*T(2)));
g1(2,18)=exp(y(18));
g1(2,32)=(-(params(11)*T(8)*T(28)));
g1(2,35)=(-(T(10)*params(11)*T(29)));
g1(3,35)=(-(T(12)*T(3)*T(11)*T(2)*(1-params(11))*(1-params(3))*T(29)));
g1(3,13)=(-(T(12)*(T(8)*T(2)*(1-params(11))*(1-params(3))*T(11)*T(30)+T(3)*T(8)*T(2)*(1-params(11))*(1-params(3))*T(4)*T(30)*T(32))));
g1(3,37)=(-(T(12)*T(3)*T(8)*T(2)*(1-params(11))*(1-params(3))*T(32)*T(38)+T(3)*T(8)*T(2)*(1-params(11))*(1-params(3))*T(11)*T(39)));
g1(3,40)=exp(y(40));
g1(3,42)=(-(T(12)*T(3)*T(11)*T(8)*(1-params(11))*(1-params(3))*T(1)*T(2)));
g1(4,35)=(-(T(4)*T(13)*T(11)*T(2)*(1-params(11))*params(3)*T(29)));
g1(4,13)=(-(T(4)*(T(13)*T(8)*T(2)*(1-params(11))*params(3)*T(4)*T(30)*T(32)+T(11)*T(8)*T(2)*(1-params(11))*params(3)*T(33))));
g1(4,37)=(-(T(11)*T(8)*T(2)*(1-params(11))*params(3)*T(13)*T(37)+T(4)*T(13)*T(8)*T(2)*(1-params(11))*params(3)*T(32)*T(38)));
g1(4,39)=exp(y(39));
g1(4,42)=(-(T(4)*T(13)*T(11)*T(8)*(1-params(11))*params(3)*T(1)*T(2)));
g1(5,29)=exp(y(29));
g1(5,13)=(-(exp(y(37)*(1-params(3)))*T(2)*params(3)*exp(y(13)*params(3))));
g1(5,37)=(-(T(2)*exp(y(13)*params(3))*(1-params(3))*exp(y(37)*(1-params(3)))));
g1(5,42)=(-(exp(y(37)*(1-params(3)))*exp(y(13)*params(3))*T(1)*T(2)));
g1(6,19)=exp(y(19));
g1(6,20)=exp(y(20));
g1(6,6)=params(6)*exp(params(5)*(y(10)-y(43)))*exp(y(6));
g1(6,7)=params(6)*exp(params(5)*y(11))*exp(y(7));
g1(6,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(43)));
g1(6,11)=exp(y(7))*params(6)*params(5)*exp(params(5)*y(11));
g1(6,35)=(-exp(y(35)));
g1(6,13)=(-(exp(y(13))*(1-params(10))));
g1(6,36)=exp(y(36));
g1(6,38)=exp(y(38));
g1(6,43)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(43)))*(-params(5));
g1(7,37)=exp(y(37));
g1(7,40)=(-(T(14)*T(44)));
g1(8,56)=(-(T(15)*exp(y(56))));
g1(8,57)=(-(T(15)*(1+exp(y(56))-params(10))));
g1(9,14)=(-((-(T(17)*T(35)*T(36)))/(T(19)*T(19))));
g1(9,37)=(-(T(43)/T(19)));
g1(9,15)=(-((-(T(17)*exp(y(15))*T(36)))/(T(19)*T(19))));
g1(9,38)=(-(params(1)*exp(y(38))*T(42)/T(19)));
g1(9,41)=exp(y(41));
g1(10,51)=(-(T(15)*exp(y(28))*exp(y(51))));
g1(10,28)=(-(T(15)*(exp(y(28))*exp(y(51))+y(52)*(-exp(y(28)))-params(6)*params(5)*exp(params(5)*y(28)))));
g1(10,30)=1;
g1(10,52)=(-(T(15)*(1-exp(y(28)))));
g1(10,57)=(-(T(15)*(exp(y(28))*exp(y(51))+(1-exp(y(28)))*y(52)-params(6)*exp(params(5)*y(28)))));
g1(11,30)=(-params(7));
g1(11,31)=1;
g1(11,53)=(-(T(15)*(1-params(7))));
g1(11,57)=(-(T(15)*(1-params(7))*y(53)));
g1(12,20)=y(31)*T(20)*params(4)*(params(4)-1)*exp(y(20)*(params(4)-1));
g1(12,31)=params(4)*exp(y(20)*(params(4)-1))*T(20);
g1(13,51)=(-(T(15)*exp(y(51))));
g1(13,28)=T(15)*params(6)*params(5)*(params(5)-1)*exp(y(28)*(params(5)-1));
g1(13,52)=T(15);
g1(13,57)=T(15)*params(6)*params(5)*exp(y(28)*(params(5)-1))-T(15)*(exp(y(51))-y(52));
g1(14,51)=(-(T(15)*exp(y(51))*exp((-y(58)))*exp(y(27))));
g1(14,27)=T(25);
g1(14,33)=1;
g1(14,54)=(-(T(15)*(1-exp((-y(58)))*exp(y(27)))));
g1(14,57)=(-T(21));
g1(14,58)=T(45);
g1(15,33)=(-params(7));
g1(15,34)=1;
g1(15,55)=(-(T(15)*(1-params(7))));
g1(15,57)=(-(T(15)*(1-params(7))*y(55)));
g1(16,19)=y(34)*T(22)*params(4)*(params(4)-1)*exp(y(19)*(params(4)-1));
g1(16,34)=params(4)*exp(y(19)*(params(4)-1))*T(22);
g1(17,51)=(-(exp(y(51))*T(15)*exp((-y(58)))));
g1(17,27)=T(15)*exp(y(58)*(-params(5)))*params(6)*params(5)*(params(5)-1)*exp((params(5)-1)*y(27));
g1(17,54)=T(15)*exp((-y(58)));
g1(17,57)=T(15)*params(6)*params(5)*exp((params(5)-1)*y(27))*exp(y(58)*(-params(5)))-T(15)*exp((-y(58)))*(exp(y(51))-y(54));
g1(17,58)=T(46);
g1(18,7)=(-(exp(y(7))*(1-exp(y(11)))));
g1(18,24)=exp(y(24));
g1(18,26)=(-(params(7)*exp(y(26))));
g1(18,11)=(-(exp(y(7))*(-exp(y(11)))));
g1(19,6)=(-(exp(y(6))*(1-exp((-y(43)))*exp(y(10)))));
g1(19,23)=exp(y(23));
g1(19,25)=(-(params(7)*exp(y(25))));
g1(19,10)=(-(exp(y(6))*(-(exp((-y(43)))*exp(y(10))))));
g1(19,43)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(43))))))));
g1(20,20)=(-(T(20)*params(4)*exp(y(20)*params(4))));
g1(20,9)=(-((1-params(7))*exp(y(9))));
g1(20,26)=exp(y(26));
g1(21,19)=(-(T(22)*params(4)*exp(y(19)*params(4))));
g1(21,8)=(-((1-params(7))*exp(y(8))));
g1(21,25)=exp(y(25));
g1(22,22)=exp(y(22));
g1(22,7)=(-(exp(y(7))*exp(y(11))));
g1(22,11)=(-(exp(y(7))*exp(y(11))));
g1(23,21)=exp(y(21));
g1(23,6)=T(23);
g1(23,10)=T(23);
g1(23,43)=(-(exp(y(6))*exp(y(10))*(-exp((-y(43))))));
g1(24,21)=(-exp(y(21)));
g1(24,22)=(-exp(y(22)));
g1(24,32)=exp(y(32));
g1(25,43)=1;
g1(25,59)=(-1);
g1(26,16)=(-params(15));
g1(26,42)=1;
g1(26,60)=(-1);
g1(26,17)=(-params(16));
g1(27,1)=1;
g1(27,18)=(-1);
g1(27,44)=1;
g1(28,3)=1;
g1(28,20)=(-1);
g1(28,45)=1;
g1(29,2)=1;
g1(29,19)=(-1);
g1(29,46)=1;
g1(30,5)=1;
g1(30,22)=(-1);
g1(30,47)=1;
g1(31,4)=1;
g1(31,21)=(-1);
g1(31,48)=1;
g1(32,12)=1;
g1(32,35)=(-1);
g1(32,49)=1;
g1(33,16)=(-1);
g1(33,50)=1;

end
